using System;
using System.Data;
using System.Data.SqlClient;

using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
	
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Greg Lohse</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>12/02/2008</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///VBECSVersion - Created for CR2465
	///</summary>

	#endregion

	public class VbecsVersion
	{


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/2/2008</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8854"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>DataTable of VbecsVersion table</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8855"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns the entire VbecsVersion table, sorted descing on LastUpdateDate, so the most recent version is record 0
		/// </summary>
		/// <returns></returns>
		public static DataTable GetVbecsVersion()
		{
			return Common.StoredProcedure.GetDataTable( STOREDPROC.GetVbecsVersion.StoredProcName );
		}

        ///<Developers>
        ///	<Developer>Greg Lohse</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>12/2/2008</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="8854"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>DataTable of VbecsVersion table</ExpectedOutput>
        ///	</Case>
        ///
        ///
        ///<Case type="1" testid ="8855"> 
        ///		<ExpectedInput>NA</ExpectedInput>
        ///		<ExpectedOutput>NA</ExpectedOutput>
        ///	</Case>
        ///
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// Returns the entire VbecsVersion table, sorted descing on LastUpdateDate, so the most recent version is record 0 CR 3453
        /// </summary>
        /// <returns></returns>
        public static DataTable GetVbecsRevision()
        {
            return Common.StoredProcedure.GetDataTable(STOREDPROC.GetVbecsRevision.StoredProcName);
        }
	}
}
